﻿
/****************************************************************************/
/*Copyright (c) 2011, Florent DEVILLE.                                      */
/*All rights reserved.                                                      */
/*                                                                          */
/*Redistribution and use in source and binary forms, with or without        */
/*modification, are permitted provided that the following conditions        */
/*are met:                                                                  */
/*                                                                          */
/* - Redistributions of source code must retain the above copyright         */
/*notice, this list of conditions and the following disclaimer.             */
/* - Redistributions in binary form must reproduce the above                */
/*copyright notice, this list of conditions and the following               */
/*disclaimer in the documentation and/or other materials provided           */
/*with the distribution.                                                    */
/* - The names of its contributors cannot be used to endorse or promote     */
/*products derived from this software without specific prior written        */
/*permission.                                                               */
/* - The source code cannot be used for commercial purposes without         */
/*its contributors' permission.                                             */
/*                                                                          */
/*THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS       */
/*"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT         */
/*LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS         */
/*FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE            */
/*COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,       */
/*INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,      */
/*BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;          */
/*LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER          */
/*CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT        */
/*LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN         */
/*ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE           */
/*POSSIBILITY OF SUCH DAMAGE.                                               */
/****************************************************************************/

using System.Reflection;

using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;

using GE.Manager;

namespace GE.Gui
{
    /// <summary>
    /// A text bitmap widget.
    /// </summary>
    class WBitmapButton : WButton
    {
        /// <summary>
        /// Constructor.
        /// </summary>
        /// <param name="owner">owner</param>
        /// <param name="image">image</param>
        /// <param name="focusImage">image when focused</param>
        /// <param name="position">position</param>
        public WBitmapButton(Window owner, string image, string focusImage, Vector2 position)
        {
            m_owner = owner;
            m_position = position;
            m_isFocused = false;
            m_clickCallback = null;
            m_focusCallback = null;
            m_image = new WImage(image, new Vector2(0f, 0f));
            m_focusImage = new WImage(focusImage, new Vector2(0f, 0f));
            m_text = null;
        }

        /// <summary>
        /// Render.
        /// </summary>
        /// <param name="offset">position offset</param>
        public override void render(Vector2 offset)
        {
            if (!m_isFocused)
                m_image.render(offset + m_position);
            else
                m_focusImage.render(offset + m_position);
        }
    }
}
